/* Agent Tcl
   Bob Gray
   29 September 1995

   platSigio.h

   This file defines the class which handles the SIGIO interrupt.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIGIO_H
#define _PLAT_SIGIO_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

    /* forward declarations */

class MonitorGroup;
class SigioHandlerImp;

    /* any class that needs a SIGIO interrrupt inherits class SigioTrap */

class SigioTrap
{
public:

	/* 
	 * A SigioTrap instance is passed to SigioHandler.  SigioHandler      
	 * invokes the "sigioAlarm" method as soon as the associated fd is   
	 * ready for reading, writing or exception processing (or some subset
	 * if the higher layer specifies only a subset when creating the    
	 * SigioHandler).  The "flags" paramater is an OR'ed combination of 
	 * e_READ_READY, e_WRITE_READY and e_EXCEPT_READY and indicates   
	 * whether the fd is ready for reading, writing or exception     
	 * handling.                                                    
	 */

    virtual void sigioAlarm (int fd, int flags) = 0;

    enum SigioStatus {
	e_READ_READY	  = 0x1,
	e_WRITE_READY	  = 0x2,
	e_EXCEPT_READY	  = 0x4
    };
};
 
  /* SIGIO handler */

class SigioHandler
{
    static BOOLEAN m_sigioFired;	/* SIGIO has fired        */
    SigioHandlerImp *m_this;		/* implementation details */

public:

	/*
	 * Since it is unsafe to use select, etc., inside a signal handler,
	 * the following four functions are used in runtime environments that
	 * do not have threads.  They have no effect in runtime environments 
	 * that do have threads.
	 */

	/*
	 * Mark that SIGIO has fired
	 */

    static void markSigioFired (void) {
	m_sigioFired = e_TRUE;
    }

	/*
	 * See if SIGIO has fired
	 */

    static BOOLEAN hasSigioFired (void) {
	BOOLEAN sigioFired = m_sigioFired;
	m_sigioFired = e_FALSE;
	return (sigioFired);
    }

	/*
	 * Set the trap that is called on any SIGIO.  This general trap
	 * should eventually call the function checkAndCallTraps, which
	 * checks the invidual file descriptiors and calls the file descriptor
	 * traps.
	 */

    static void setGeneralTrap (SigioTrap *trap);

	/*
	 * Check if there is any activity on the monitored file decriptors and 
	 * call the appropriate file descriptor traps
	 */

    static void checkAndCallTraps (void);

	/* constructor and destructor */

    SigioHandler (int fd, SigioTrap *trap, int flags, const MonitorGroup &group);
   ~SigioHandler ();

	/* change the I/O events for which we want a callback */

    void changeFlags (int flags);

private:
	
	/* copy constructor and assignment operator are not supported */

    SigioHandler (const SigioHandler&);
    SigioHandler& operator= (const SigioHandler &);
};

#endif
