/* Agent Tcl
   Bob Gray
   28 March 1997

   platSigterm.h

   This file defines the class which handles the SIGTERM interrupt.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIGTERM_H
#define _PLAT_SIGTERM_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

    /* forward declarations */

class SigtermHandlerImp;

    /* any class that needs a SIGTERM interrrupt inherits class SigtermTrap */

class SigtermTrap
{

public:

    virtual void sigtermAlarm (void) = 0;
};
 
  /* SIGTERM handler */

class SigtermHandler
{
    SigtermHandlerImp *m_this;      /* implementation details */ 

public:

	/* set the desired exit code */

    static void setExitCode (int exitcode);

	/* constructor and destructor */

    SigtermHandler (SigtermTrap *trap);
   ~SigtermHandler ();
};

#endif
