/* Agent Tcl
   Bob Gray
   16 November 1996

   platSizes.h

   This file defines 8, 16 and 32 bit integers.

   Copyright (c) 1995-1997, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIZES_H
#define _PLAT_SIZES_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

    /* integer types */

#define INT_8	signed char
#define INT_16	signed short
#define INT_32	signed int
#define UINT_8	unsigned char
#define UINT_16	unsigned short
#define UINT_32 unsigned int

    /* minimum and maximum values */

const INT_8 MAX_8   = 0x7f;
const INT_8 MIN_8   = 0x80;
const UINT_8 MAX_U8  = 0xff;
const INT_16 MAX_16  = 0x7fff;
const INT_16 MIN_16  = 0x8000;
const UINT_16 MAX_U16 = 0xffff;
const INT_32 MAX_32  = 0x7fffffff;
const INT_32 MIN_32  = 0x80000000;
const UINT_32 MAX_U32 = 0xffffffff;

#endif
