/* Agent Tcl
   Bob Gray
   9 February 1995

   platSocket.h

   This file defines socket-related functions.

   Copyright (c) 1995-2000, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_IO_H
#define _PLAT_IO_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

class SocketIO
{
public:

	/* error codes */

    enum SocketErrors {
	e_ControlError = 0,
	e_Ok	       = 1
    };

	/* turn on asynchronous I/O (i.e., SIGIO interrupts) for the socket */

    static SocketErrors markAsynchronous (int sockfd);

	/* turn off asynchronous I/O (i.e., SIGIO interrupts) for the socket */

    static SocketErrors markSynchronous (int sockfd);
};

#endif
