/* Agent Tcl
   Bob Gray
   28 Spetember 1995

   platSystem.h

   This file defines a class that allows a process to perform certain
   system-level operations.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SYSTEM_H
#define _PLAT_SYSTEM_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

     /* forward declarations */
    
struct timeval;
 
class SystemUtil
{
    public:
	
	    /* 
	     * convert a system errno into a string
	     */

	static const char *errnoToShortString (int errorNo);
	static const char *errnoToLongString (int errorNo);

	    /* 
             * get the current wall and cpu time 
             */

	static struct timeval getCurrentWall (void);
	static struct timeval getCurrentCpu (void);

	    /* 
             * set the CPU time used so far (i.e., this amount will be ADDED
	     * to the process's CPU time usage inside the getCurrentCpu
	     * method to get the CPU usage so far).
             */

        static void setElapsedCpu (struct timeval start);

	    /*
             * "reset" the process's CPU usage to zero (we do this by 
	     * remembering the current CPU usage and subtracting inside
	     * getCurrentCpu
	     */

	static void resetCpuTime (void);

	    /* 
	     * initialize a raw file descriptor (e.g., in Java, create an 
	     * entry in the monitor table)                          
	     */

	static void initializeRawFd (int fd);
};

#endif
