/* Agent Tcl
   Bob Gray
   26 January 1997 

   platTimeval.h

   This file defines a set of utility routines for working with timevals. 

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_TIMEVAL_H
#define _PLAT_TIMEVAL_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

struct timeval;

class TimevalUtil
{
    public:

	    /* convert between timevals and seconds */ 

	static struct timeval secondsToTimeval (double seconds);
	static double timevalToSeconds (struct timeval tv);

	    /* compare, add and subtract timevals */

	static int compareTimevals (struct timeval t1, struct timeval t2);
	static struct timeval addTimevals (struct timeval t1, struct timeval t2);
	static struct timeval subTimevals (struct timeval t1, struct timeval t2);
};

#endif
