/* Agent Tcl
   Bob Gray
   9 February 1995

   truefalse.h

   This file defines TRUE and FALSE integer constants as well as the
   BOOLEAN enumerated type.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TRUEFALSE_H
#define _TRUEFALSE_H

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

enum BOOLEAN { 
    e_FALSE		= 0, 
    e_TRUE		= 1 
};

enum BOOL_FORMAT
{
     e_0_1		= 0,
     e_ON_OFF		= 1,
     e_YES_NO		= 2,
     e_TRUE_FALSE	= 3,
     e_T_F		= 4
};

    /* return a string representation of a boolean value */

char *BooleanToString (BOOLEAN value, BOOL_FORMAT format);

#endif
