/* Bob Gray
   Agent Tcl
   21 January 1998

   platExclusionImp.h

   This file defines the classes that provide simple mutual exclusion.
*/

#ifndef _PLAT_EXCLUSION_IMP_H
#define _PLAT_EXCLUSION_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_THREAD_PORT_H
#include "platThreadPort.h"
#endif
#ifndef _PLAT_THREAD_H
#include "platThread.h"
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"
#endif

struct ConditionVariable
{
	// condition variable on which a thread waits if it is waiting for 
	// another thread to signal the monitor, number of threads that are 
	// waiting on the monitor and number of times that the monitor has 
	// been signalled

    CONDITION_T waitingOnCondition;
    unsigned int waitingCount;
    unsigned int signaledCount;

	// constructor and destructor

    ConditionVariable (void);
   ~ConditionVariable ();
};

struct MonitorLockImp
{
    enum {
	e_DEFAULT_CONDITION_VARIABLES = 4
    };

	// reference count and associated mutex

    static MUTEX_T referenceMutex;
    unsigned int referenceCount;

	// TheadId of the thread that is holding the monitor, number of times
	// that thread has locked the monitor, condition variable on which a
	// thread waits if the monitor is held by someone else, and associated
	// mutex

#if defined(_LINUXTHREADS) && defined(_LINUXTHREADS_NO_FAST)
    MUTEX_ATTR_T mutexAttr;
#endif
    MUTEX_T mutex;
    CONDITION_T waitingToAcquireMonitor;
    unsigned int lockCount;
    ThreadId holdingThread;

	// builtin condition variables

    ConditionVariable builtinConditionVariable;

	// user-defined condition variables

    ConditionVariable **userConditionVariables;
    int *conditionFreeList;
    int conditionFirstFree;
    UINT_32 numConditionSlots;
    
 	// constructor and destructor

    MonitorLockImp (void);
   ~MonitorLockImp ();
};

struct MutexLockImp
{
	// reference count and associated mutex

    static MUTEX_T referenceMutex;
    unsigned int referenceCount;

	//  lock mutex

#if defined(_LINUXTHREADS) && defined(_LINUXTHREADS_NO_FAST)
    MUTEX_ATTR_T mutexAttr; 
#endif
    MUTEX_T mutex;

 	// constructor and destructor

    MutexLockImp (void);
   ~MutexLockImp ();
};

#endif
