/* Agent Tcl
   Bob Gray
   29 September 1995

   platThreadImp.h

   This file defines the class which handles the creation and execution of
   threads.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_THREAD_IMP_H
#define _PLAT_THREAD_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_THREAD_PORT_H
#include "platThreadPort.h"
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"
#endif

class Thread;
class ThreadBody;

struct ThreadImp {
	
	// reference count and associated mutex

    static MUTEX_T referenceMutex;
    unsigned int referenceCount;

	// backpointer to the thread instance (once the thread starts executing), 
	// Posix thread id, and Posix thread attributes

    Thread *attachedThread;
    pthread_t posixId;
    pthread_attr_t attributes;  

	// thread body

    ThreadBody *threadBody;

	// mutex, condition variable and flag so that the thread stays
	// suspended until client calls resume

#if defined(_LINUXTHREADS) && defined(_LINUXTHREADS_NO_FAST)
    MUTEX_ATTR_T mutexAttr;
#endif
    MUTEX_T mutex;
    CONDITION_T waitingToStart;
    BOOLEAN suspended;

	// constructor and destructor

    ThreadImp (ThreadBody *threadBody);
   ~ThreadImp ();
};

inline ThreadId tidToThreadId (pthread_t tid)
{
    ThreadId threadId;

    if (sizeof(pthread_t) == sizeof(UINT_32)) {
	threadId.m_id[0] = (UINT_32) tid;
    } else {
	(void) memcpy ((char *) threadId.m_id, (char *) &tid, sizeof(pthread_t));
    }

    return (threadId);
}

#endif
