/* Agent Tcl
   Bob Gray
   14 July 1999

   platMemoryImp.cc

   This file re-defines the global C++ new and delete operators (to ensure
   that we are correctly going through the malloc defined inside the Java VM).

   Copyright (c) 1995-1999, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"

#ifdef FIX_LATER
/*
 * We should do something intelligent if we have run out of memory (rather
 * than just aborting).
 */
#endif

void *operator new (size_t size)
{
    char *ptr = (char *) malloc (size);

    if (ptr == (char *) NULL) {
	abort_with_message ("out of memory in operator new");
    }

    return (ptr);
}

void operator delete (void *ptr)
{
    if (ptr != (void *) NULL) {
	free ((char *) ptr);
    }
}

void *operator new[] (size_t size)
{
    char *ptr = (char *) malloc (size);

    if (ptr == (char *) NULL) {
	abort_with_message ("out of memory in operator new[]");
    }

    return (ptr);
}

void operator delete[] (void *ptr)
{
    if (ptr != (void *) NULL) {
	free ((char *) ptr);
    }
}
