/* Agent Tcl
   Bob Gray
   29 September 1995

   platSigioImp.h

   This file defines the class which handles the SIGIO interrupt.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIGIO_IMP_H
#define _PLAT_SIGIO_IMP_H

#ifndef _TRUEFALSE_H
#include "truefalse.h"			// BOOLEAN
#endif
#ifndef _PLAT_EXCLUSION_H
#include "platExclusion.h"		// MonitorLock and MonitorGroup
#endif
extern "C" {
#include "threads.h"			// TID
}

class SigioTrap;
class Thread;

    /* implementation details for SigioHandlerImp */ 

class SigioHandlerImp
{
    friend class SigioHandler;
    friend class SigioBody;

	/* data */ 

    int fd;                /* file descriptor                        */
    int flags;             /* flags of interest                      */
    SigioTrap *trap;       /* trap to call when SIGIO fires          */
    MonitorLock lock;      /* monitor for mutual exclusion           */
    MonitorGroup monitors; /* all monitors for mutual exclusion      */
    BOOLEAN deleted;       /* e_TRUE if handler has been deleted     */
    BOOLEAN callback;	   /* e_TRUE if we are inside the callback   */
    int sigioFd;           /* the two ends of the pipe that lets us  */	
    int controlFd;	   /* wake up the SIGIO thread even if it is */
			   /* the select call                        */

	/* create the thread that watches the file */

    void createThread (void);

	/* constructors and destructor */

    SigioHandlerImp (int fd, int flags, SigioTrap *trap, const MonitorGroup& monitors);
    SigioHandlerImp (const SigioHandlerImp &sigioHandlerImp);
   ~SigioHandlerImp ();
};

#endif
