/* Agent Tcl
   Bob Gray
   29 September 1995

   platThreadImp.h

   This file defines the class which handles the creation and execution of
   threads.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_THREAD_IMP_H
#define _PLAT_THREAD_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_THREAD_H
#include "platThread.h"		// ThreadId
#endif
extern "C" {
#include "threads.h"		// TID
}

struct ThreadImp {

	// refernence count and reference count monitor

    static unsigned int referenceKey;
    unsigned int referenceCount;

	// Java thread identification, backpointer to Thread instance,
	// and thread body

    TID javaId;
    Thread *attachedThread;
    ThreadBody *threadBody;

	// constructor and destructor

    ThreadImp (ThreadBody *threadBody);
   ~ThreadImp ();
};

inline ThreadId tidToThreadId (TID tid)
{
    ThreadId threadId;

    if (sizeof(TID) == sizeof(UINT_32)) {
	threadId.m_id[0] = (UINT_32) tid;
    } else {
	(void) memcpy ((char *) threadId.m_id, (char *) &tid, sizeof(TID));
    }

    return (threadId);
}

#endif
