/* Agent Tcl
   Bob Gray
   28 Spetember 1995

   platTimersImp.h

   This file defines the implementation of the Timers class (which allows 
   a process to define any number of timers).

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_TIMERS_IMP__H
#define _PLAT_TIMERS_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _TRUEFALSE_H
#include "truefalse.h"
#endif
#ifndef _PLAT_EXCLUSION_H
#include "platExclusion.h"
#endif
#ifndef _PLAT_TIMERS_H
#include "platTimers.h"
#endif
extern "C" {
#include "threads.h"
}
 
    /* forward declarations */

struct timeval;

    /* platform-specific timer initialization */

class TimersImplementation
{
    friend class Timers;
    friend class TimerBody;
    friend int sigprof_handler (int interrupt, void *arg, void *siginfo);

	/* data */

    int count;                    /* number of instances of Timers class */
    MonitorLock timerLock;        /* mutual exclusion                    */
    TimerQueue wallTimers;        /* heap of wall timers                 */
    TimerQueue cpuTimers;         /* heap of cpu timers                  */
    BOOLEAN threadStarted;        /* timer thread                        */

	/* constructor */

    TimersImplementation (void);
};

#endif
