/* Bob Gray
   Agent Tcl
   13 July 1996

   platExclusionImp.h

   This file defines the classes that provide simple mutual exclusion.
*/

#ifndef _PLAT_EXCLUSION_IMP_H
#define _PLAT_EXCLUSION_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H
#include "platPorting.h"		// sig_atomic_t and sigset_t
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"			// BOOLEAN
#endif

class SIGNAL_STACK;

struct MonitorLockImp
{
    static sigset_t zeroMask;		// zero mask for sigsuspend
    static sigset_t blockMask;		// signals to block
    static sigset_t oldMask;		// old signal mask
    static sig_atomic_t count;		// count of nested calls to MonitorLock::acquire
};

struct MutexLockImp;			// uses the MonitorLockImp data

#endif
