/* Agent Tcl
   Bob Gray
   14 February 1995

   interrupt.cc

   This file implements a reliable signal handler "install_signal".  This
   handler is based on the examples in "UNIX Network Programming" by W. Richard
   Stevens [Prentice-Hall, 1990].

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platInterrupt.h"

#ifdef FIX_LATER
    /* 
     * needs to use the ClientData argument
     */
#endif

void SignalHandlers::initializeSignals (void)
{
    // empty
}

int SignalHandlers::install_signal (int signo, void (*func) (int, ClientData), ClientData clientData)
{
  struct sigaction act;   /* signal handler information */

#ifdef SIGACTION_CAST
  act.sa_handler = (void (*)(...)) func;
#else
#ifdef SIGACTION_PAREN_CAST
  act.sa_handler = (void (*)()) func;
#else
  act.sa_handler = (void (*)(int)) func;
#endif
#endif
  sigemptyset (&act.sa_mask);
  act.sa_flags   = 0;

  if (signo == SIGALRM) {
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;     
#endif
  } else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#endif
  }

  if (signo == SIGCHLD) {
#ifdef SA_NOCLDSTOP
    act.sa_flags |= SA_NOCLDSTOP;
#endif
  }

  if (sigaction(signo, &act, 0) < 0) {
    return -1;
  }

  return 0;
}

int SignalHandlers::install_signal_intr (int signo, void (*func) (int, ClientData), ClientData clientData)
{
  struct sigaction act;   /* signal handler information */

#ifdef SIGACTION_CAST
  act.sa_handler = (void (*)(...)) func;
#else
#ifdef SIGACTION_PAREN_CAST
  act.sa_handler = (void (*)()) func;
#else
  act.sa_handler = (void (*)(int)) func;
#endif
#endif
  sigemptyset (&act.sa_mask);
  act.sa_flags   = 0;

  if (signo == SIGCHLD) {
#ifdef SA_NOCLDSTOP
    act.sa_flags |= SA_NOCLDSTOP;
#endif
  }

#ifdef SA_INTERRUPT
  act.sa_flags |= SA_INTERRUPT;     
#endif

  if (sigaction(signo, &act, 0) < 0) {
    return -1;
  }

  return 0;
}
