/* Agent Tcl
   Bob Gray
   27 January 1996

   genSigStack.h

   This file defines a stack which keeps track of signal sets.
 
   Copyright (c) 1995-1996 Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIG_STACK_H
#define _PLAT_SIG_STACK_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "platPorting.h"

    /* initial size of the signal stack */

const int SIGNAL_STACK_SIZE = 8;

   /* signal stack */

class SIGNAL_STACK
{
	/* signal stack */

    sigset_t *stack;

	/* number of slots in the signal stack */

    int slots;

	/* number of occupied slots on the signal stack */

    int n;

public:

	/* push a signal set onto the stack */

    void push (sigset_t set) {

	    /* expand the stack if necessary */

	if (n == slots) {

	    sigset_t *newStack = new sigset_t [slots << 1];

	    for (register int i = 0; i < slots; i++) {
		newStack[i] = stack[i];
	    }

	    slots = slots << 1;
	    delete (stack);
	    stack = newStack;
 	}

	stack[n++] = set; 
    };

	/* pop a signal set off the stack */

    sigset_t pop (void) {
	assert (n > 0);
	return (stack[--n]);
    };

	/* constructor */

    SIGNAL_STACK (void) {
	n     = 0;
	slots = SIGNAL_STACK_SIZE;
	stack = new sigset_t [slots];
    };

	/* destructor */

   ~SIGNAL_STACK () {
	delete (stack);
    };
};

#endif /* _PLAT_SIG_STACK */

