/* Agent Tcl
   Bob Gray
   29 September 1995

   platSigioImp.h

   This file defines the class which handles the SIGIO interrupt.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIGIO_IMP_H
#define _PLAT_SIGIO_IMP_H

#ifndef _PLAT_PORTING_H
#include "platPorting.h"	// fd_mask and MASK_SIZE
#endif
#ifndef _PLAT_EXCLUSION_H
#include "platExclusion.h"	// MonitorGroup
#endif
#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif

    /* forward declarations */

class SigioTrap;

    /* implementation details for SigioHandlerImp */ 

class SigioHandlerImp
{
    friend class SigioHandler;
    friend void gen_sigio_handler (int, SignalHandlers::ClientData);

	/* static data */

    static int count;                /* number of instances of this class    */
    static fd_mask rset[MASK_SIZE];  /* monitored read fd's                  */
    static fd_mask wset[MASK_SIZE];  /* monitored write fd's                 */
    static fd_mask eset[MASK_SIZE];  /* monitored exception fd's             */
    static int maxSockfd;            /* maximum sockfd                       */
    static int rcount;		     /* number of monitored read fd's        */
    static int wcount;		     /* number of monitored write fd's       */
    static int ecount;		     /* number of monitored exception fd's   */
    static SigioHandlerImp *head;    /* head of the list of instances        */
    static MonitorLock *lock;        /* mutual exclusion                     */
    static SigioTrap *sigioTrap;     /* trap called on any SIGIO             */
    static BOOLEAN callback;         /* e_TRUE if we are inside the callback */

	/* instance data */
 
    SigioHandlerImp *previous;       /* previous instance in the list        */
    SigioHandlerImp *next;           /* next instance in the list            */
    int fd;                          /* file descriptor of interest          */
    SigioTrap *trap;                 /* trap to call when SIGIO fires        */
    int fdindex;		     /* index in set that contains fd        */
    fd_mask fdbit;		     /* bit for the fd                       */
    int flags;                       /* events of interest                   */ 
};

#endif
