/* Agent Tcl
   Bob Gray
   27 March 1997

   platSigtermImp.h

   This file defines the class which handles the SIGTERM interrupt.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_SIGTERM_IMP_H
#define _PLAT_SIGTERM_IMP_H

#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif

    /* forward declarations */

class SigtermTrap;

    /* implementation details for SigioHandlerImp */ 

class SigtermHandlerImp
{
    friend class SigtermHandler;
    friend void gen_sigterm_handler (int, SignalHandlers::ClientData);

	/* static data */

    static int count;			// number of instances of this class
    static int exitcode;	  	// exit code
    static SigtermHandlerImp *head;	// head of the list of instances

	/* instance data */
 
    SigtermHandlerImp *previous;	// previous instance in the list
    SigtermHandlerImp *next;		// next instance in the list
    SigtermTrap *trap;			// trap to call when SIGTERM fires 
};

#endif
