/*
 * charset.c
 *
 * Conversion tables and routines to support different character sets.
 * The PGP internal format is latin-1.
 *
 * (c) Copyright 1990-1994 by Philip Zimmermann.  All rights reserved.
 * The author assumes no liability for damages resulting from the use
 * of this software, even if the damage results from defects in this
 * software.  No warranty is expressed or implied.
 *
 * Code that has been incorporated into PGP from other sources was
 * either originally published in the public domain or is used with
 * permission from the various authors.
 *
 * PGP is available for free to the public under certain restrictions.
 * See the PGP User's Guide (included in the release package) for
 * important information about licensing, patent restrictions on
 * certain algorithms, trademarks, copyrights, and export controls.
 */

#include <stdio.h>
#include <string.h>
#include "usuals.h"
#include "charset.h"
#include "system.h"

#ifndef NULL
#define	NULL	0
#endif

#define UNK	'?'

/*
 * Most Unixes has KOI8, and DOS has ALT_CODE
 * If your Unix is non-standard, set CHARSET to "alt_codes"
 * in config.txt
 */

#ifndef	DEFAULT_CSET
#define	DEFAULT_CSET	"noconv"
#endif
#ifndef	DEFAULT_RU_CSET
#define	DEFAULT_RU_CSET	"noconv"
#endif

/* End of Russian section */

int CONVERSION = NO_CONV;      /* None text file conversion at start time */

unsigned char *ext_c_ptr;
static unsigned char *int_c_ptr;

#ifdef MSDOS
char charset[64] = "cp850";
#else
char charset[64] = "";
#endif

char
EXT_C(char c)
{
	if (c > '\0' || !ext_c_ptr)
		return c;
	return ext_c_ptr[c & 0x7f];
}

char
INT_C(char c)
{
	if (c > '\0' || !int_c_ptr)
		return c;
	return int_c_ptr[c & 0x7f];
}

/*
 * to_upper() and to_lower(), replacement for toupper() and tolower(),
 * calling to_upper() on uppercase or to_lower on lowercase characters
 * is handled correctly.
 * 
 * XXX: should handle local characterset when 8-bit userID's are allowed
 */
int
to_upper(int c)
{
	return (c >= 'a' && c <= 'z' ? c - ('a' - 'A') : c);
}

int
to_lower(int c)
{
	return (c >= 'A' && c <= 'Z' ? c + ('a' - 'A') : c);
}
