/* Agent Tcl
   Bob Gray
   8 September 1995

   restrictTcl.h

   This file defines the library routines that handle restrictions.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _RESTRICT_TCL_H
#define _RESTRICT_TCL_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifdef __cplusplus
#define EXTERNAL extern "C"
#else
#define EXTERNAL extern
#endif

/* 
 * forward declarations 
 */

class Permit;
struct Tcl_Interp;

/*
 * initialize
 */

EXTERNAL int Restrict_Init 
    (Tcl_Interp *interp);

/*
 * parse a permit
 */

EXTERNAL int Restrict_ParsePermit 
    (Tcl_Interp *interp, char *string, Permit *permit);

/*
 * add and remove a permit
 */

EXTERNAL int Restrict_Add
    (Tcl_Interp *interp, Permit *permit);

EXTERNAL int Restrict_Remove
    (Tcl_Interp *interp);

#endif
