# Agent Tcl
# Bob Gray
# 15 July 1995
#
# agent.tcl --
#
# Defines agent_meet and other agent commands 

#
# set floating-point precision to the maximum precision
#

set tcl_precision $agent(maxprecision)
glue var tcl_precision

#
# agent_submit_file
#
# Purpose: agent_submit_file has proven to be our most useful "utility" routine
#	   so we have moved it into the core -- it submits the complete contents
#          of a file (plus a command line) as an agent.  Any occurrence
#          of %P in the command line is replaced with the 4-element id of
#          the submitting agent.
#

proc agent_submit_file {machine agentfile cmdline} glue {

    global agent

	# read the file

    set fid [open $agentfile]
    set script [read $fid]
    close $fid

	# replace any occurence of "%P" in the command line with the
	# 4-element id of the submitting agent -- i.e., with the 4-element
	# id of the submitted agent's PARENT

    regsub -all "%P" $cmdline [list $agent(local)] cmdline

	# submit the agent which consists of the file and the command line

    set muppet [agent_submit $machine -script "$script\n$cmdline"]
    return $muppet
}

#
# tcpip_read, tcpip_write and tcpip_close
#
# Purpose: These procedures are defined for backwards compatibility.   They
#          simply call meeting_receive, meeting_send and meeting_close
#          respectively.
#

proc tcpip_read {handle args} glue {
    eval meeting_receive $handle code string $args
    return $string
}

proc tcpip_write {handle string} glue {
    meeting_send $handle 0 $string
}

proc tcpip_close {handle} glue {
    meeting_close $handle
}

#
# mask_swap
#
# Purpose: Replace the message, meeting or event mask 
#
#   Input: name   = "message", "meeting" or "event"
#          handle = handle of the new mask 
#
#  Output: The procedure replaces and returns the handle of the old mask.
#

proc mask_swap {name handle} glue {

    global mask   

    set old_handle [set mask($name)]
    set mask($name) $handle
    return $old_handle 
}

#
# mask_replace
#
# Purpose: Replace the message, meeting or event mask
#
#   Input: name   = "message", "meeting" or "event"
#          handle = handle of the new mask
#
#  Output: The procedure replaces the old mask and returns the empty string.
#          The old mask is DELETED if it is not duplicated as one of the other
#          two special masks.
#

proc mask_replace {name handle} glue {

    global mask  

	# nothing to do if the new mask is the same as the current mask

    if {$handle == $mask($name)} {
	return
    }

	# otherwise move in the new mask and delete the old one

    set count 0
    set old $mask($name)

    foreach i {message meeting event} {
	if {$mask($i) == $old} {
	    incr count
	}
    }

    set mask($name) $handle

    if {$count == 1} {
	mask delete $old
    }

    return
}
