# parray:
# Print the contents of a global array on stdout.
#
# @(#) parray.tcl 1.8 95/03/29 10:26:43
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1996 Robert S. Gray, Dartmouth College
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# Modifications:
#
# 04/02/96: Now returns the information rather than printing it to standard
#           output (RSG).  This makes it a much more useful tool.

proc parray {a {pattern *}} glue {

    upvar 1 $a array

    if ![array exists array] {
	error "\"$a\" isn't an array"
    }

    set maxl 0

    foreach name [lsort [array names array $pattern]] {
	if {[string length $name] > $maxl} {
	    set maxl [string length $name]
	}
    }

    set maxl [expr {$maxl + [string length $a] + 2}]
    set list {}

    foreach name [lsort [array names array $pattern]] {
	lappend list [list $name $array($name)]
	append list \n
    }

    return $list
}
