# Agent Tcl
# Bob Gray
# 30 September 1996 
#
# random.tcl
#
# This file defines the "toprand" command which provides a graphical
# interface to the trueseed command (or simply calls the trueseed
# command if Tk is not available).

proc toprand {w title bits} {

    global tkPriv

    if {[info command winfo] == ""} {

	trueseed $bits

   } elseif {![winfo exists .]} {

	trueseed $bits

   } else {

	    # set the tkPriv elements

	set tkPriv(bits) $bits
	catch {unset tkPriv(button)}

	    # create the toplevel window

	toplevel $w

	    # set the window title

	wm title $w $title

	    # make some frames
	
	frame $w.bot -relief raised -bd 1
	pack $w.bot -side bottom -fill both
	frame $w.top -relief raised -bd 1
	pack $w.top -side top -fill both -expand 1

	    # pack in the informational message

	text $w.info -bd 0 -wrap word -height 5
	$w.info insert end "The program needs to generate $bits random bits.  It will do this by measuring the time between your keystrokes.  Please type on the keyboard until the count below goes to 0."
	$w.info configure -state disabled
	pack $w.info -in $w.top -side top -fill both -expand 1

	    # pack in the bit counts

	label $w.count -text "Bits to go: $tkPriv(bits)"
	pack $w.count -in $w.bot -side top -fill both -expand 1

	    # withdraw the window so we can calculate how big the window is

	wm withdraw $w
	update idletasks
	set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
	set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
	wm geom $w +$x+$y
	wm deiconify $w

	    # make the keyboard bindings 

	bind $w <KeyPress> {

	    set tkPriv(key) %A

	    if {$tkPriv(key) != ""} {
		set tkPriv(bits) [expr $tkPriv(bits) - [trueevent $tkPriv(key)]]
	    }

	    %W.count configure -text "Bits to go: $tkPriv(bits)"

	    if {$tkPriv(bits) <= 0} {
		set tkPriv(button) 1
	    }
	}

	    # remember the focus and the grab

	set oldFocus [focus]
	set oldGrab [grab current .]

	if {$oldGrab != ""} {
	    set grabStatus [grab status $oldGrab]
	}

	    # grab the display

	grab $w
        focus $w

	    # wait until done

	tkwait variable tkPriv(button)

	    # restore the old focus and the old grab

	if {$oldFocus != ""} {
	    focus $oldFocus
	}

	if {$oldGrab != ""} {
	    if {$grabStatus == "global"} {
		grab -global $oldGrab
	    } else {
		grab $oldGrab
	    }
	}

	    # destroy the window

	destroy $w
   }
}
