@TCL_STARTUP@

# Agent Tcl
# Bob Gray
# 8 April 1997
#
# This agent kills all agents that are currently running (except for the
# resource-manager agent which is essential to system operation).

    # turn on signatures

if {[lindex $argv 0] != "-nosecurity"} {
    security signatures on
}

    # register the agent

agent_begin

    # get the numeric id of the resource-manager

set managerId {}

catch {
    set info [agent_info -id "$agent(local-ip) resource-manager"]
    set fullId [lindex $info 0]
    set managerId [lindex $fullId 3]
}

    # kill all agents except for the resource-manager and this agent

set ids [agent_info -ids $agent(local-ip)]

foreach id $ids {

    if {$id == $agent(local-id)} {
	continue
    }

    if {($managerId != "") && ($managerId == $id)} {
	continue
    }

    puts "Forcing agent $id ..."
    agent_force "$agent(local-ip) $id"
}

    # done

agent_end
