@TCL_STARTUP@

# Agent Tcl
# Bob Gray
# 25 October 1995
#
# machine.tcl (CS version)
#
# Description:
#
# This agent checks if the server is running on one or more machines.
#
# Usage:
#
# machine.tcl [ all | name [ name ... ]]
#
# If there are  no arguments, the agent prints the list of machines on which 
# the server should be running.  If the first argument is "all", the agent
# checks that the server is running on all of the machines.  Otherwise
# the agent checks that the server is running on the machines listed as
# arguments.

# -----------------------------------------------------------------------------
# START MODIFYING HERE
# -----------------------------------------------------------------------------

  # location of the sendmail program

set sendmail /usr/bin/sendmail

  # recipient address

set recipient rgray@coos.dartmouth.edu

  # number of seconds between checks

set timeout [expr 6 * 60 * 60]

  # list of machines -- make sure that you replace these with your machines

set machines { \
	bald.cs.dartmouth.edu \
	muir.cs.dartmouth.edu \
	tuolomne.cs.dartmouth.edu \
	tenaya.cs.dartmouth.edu \
	tioga.cs.dartmouth.edu \
}
  
# -----------------------------------------------------------------------------
# STOP MODIFYING HERE
# -----------------------------------------------------------------------------

  # utility routine to both echo and append to list

proc echo {listName background message} {

    global $listName

    append $listName $message

    if {$background == 0} {
	puts -nonewline stdout $message
 	flush stdout
    }
}

  # no arguments means to just print the list of machines

if {$argc == 0} {

    set machines [lsort $machines]

    puts "\nAgent Tcl server should be running on ...\n"

    foreach m $machines {
	puts $m
    }

    puts ""
    exit
}

  # determine which machines to check

if {[lindex $argv 0] == "all-back"} {

    set background 1

} else {

    set background 0

    if {[lindex $argv 0] != "all"} {
	set machines $argv
    }
}

  # register the agent

if {$background} {
    security signatures on
}

if {[catch {agent_begin}]} {
    return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {$background} {
    agent_name server-monitor 
}

  # loop forever

while {1} {

    set output {}
    set errorOutput {}
    set submitted 0
    set received 0
    set errors 0
    set xerrors 0

    foreach m $machines {
	catch {unset error($m)}
	catch {unset xerror($m)}
	catch {unset response($m)}
    }

	# throw out any old messages

    while {[agent_receive code string -nonblocking] != "-1"} {
	# empty
    }
 
	# submit the test agents

    echo output $background "\nSubmitting the agents:\n\n"
    
    set script {
	set id [
	    agent_submit $m -time 10.0 -script {return HELLO}
	]
    }

    foreach m $machines {

	echo output $background "$m ... "

	if {[catch $script result]} {
	    echo output $background "FAILED\n"
	    incr errors
	    set error($m) $result
	} else {
	    echo output $background "OKAY\n"
	    incr submitted
	    set response([lindex $id 0]) 0
	}
    }

	# wait for the responses

    if {$submitted > 0} {

	echo output $background "\nWaiting for results:\n\n"
  
	for {set i 1} {$i <= $submitted} {incr i} {

	    set source [agent_receive code string -time 15.0]

	    if {$source == "-1"} {
	        echo output $background "TIMEOUT\n"
		break;
	    }

	    incr received
	    set machine [lindex $source 0]
	    set response($machine) 1

	    if {$code == 1} {
		set xerror([lindex $source 0]) $string
		incr xerrors
		echo output $background "$machine ... FAILED\n"
	    } else {
	 	echo output $background "$machine ... OKAY\n"
	    }
	}  
    }

	# output any error conditions

    set any_error 0

    echo errorOutput $background "\n**** ERRORS ****\n"

    if {$errors != 0} {

	set any_error 1

	echo errorOutput $background "\nUnable to submit to the following machines:\n\n"

	foreach m [array names error] {
	    echo errorOutput $background "$m ($error($m))\n"
	} 
    }

    if {$received != $submitted} {

	set any_error 1
  
	echo errorOutput $background "\nNo response from the following machines:\n\n"

	foreach m [array names response] {
	    if {$response($m) == 0} {
		echo errorOutput $background "$m\n"
	    }
	}
    }   

    if {$xerrors != 0} {

	set any_error 1

	echo output $background "\nBad response from the following machines:\n\n"

	foreach m [array names xerror] {
	    echo errorOutput $background "$m ($xerror($m))\n"
	} 
    }

    if {$any_error == 0} {
	echo errorOutput $background "\nNone\n"
    }

	# break out of the while loop if we are not running in the background

    if {$background == 0} {
	break;
    }

	# send mail to recipient

    set fd [open /tmp/smon.mail w 0600]
    puts $fd "Subject: Agent Tcl administration"
    puts $fd $errorOutput
    puts $fd ""
    puts $fd $output
    close $fd

    exec $sendmail $recipient < /tmp/smon.mail

	# sleep until the next go-around

    agent_sleep $timeout
}

agent_end
