/* Agent Tcl
   Bob Gray
   15 February 1995

   agent_set.h

   This file defines the structures that keep track of agent data.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.

   RCS INFORMATION:

   $Id: agent_set.h,v 1.5 2001/05/06 21:26:32 rgray Exp $

   $Log: agent_set.h,v $
   Revision 1.5  2001/05/06 21:26:32  rgray
   Fixes
   Sun May  6 17:26:32 EDT 2001

   Revision 1.4  1998/08/10 14:57:35  rgray
   updated messaging system
   Mon Aug 10 10:57:35 EDT 1998

   Revision 1.3  1998/03/04 02:01:55  rgray
   fixed a server bug and an Agent Java bug and added MACE 2.0
   Tue Mar  3 21:01:55 EST 1998

   Revision 1.2  1998/01/18 20:05:27  rgray
   various bug fixes
   Sun Jan 18 15:05:27 EST 1998

   Revision 1.1  1997/10/17 06:02:02  rgray
   Initial revision

   Revision 1.1  1997/10/17 05:51:23  rgray
   Initial revision

   Revision 1.1  1997/10/17 05:43:33  rgray
   Initial revision

   Revision 1.9  1997/05/03 18:30:52  rgray
   fixed pragmas

 * Revision 1.8  1997/04/10  16:57:08  rgray
 * lots
 *
   Revision 1.7  1997/04/04 15:26:37  rgray
   switched from AGENT_ID to AgentId

   Revision 1.6  1997/03/26 16:02:44  rgray
   server now deleted any pending events for an agent when that agent ends
   (it is now impossible for any agent to use up more and more server storage)

   Revision 1.5  1997/03/26 15:11:33  rgray
   server now uses a PointerList for name events

   Revision 1.4  1997/03/25 20:26:38  rgray
   server now enforces restriction on number of pending status events

   Revision 1.3  1997/03/25 19:09:51  rgray
   added RCS comments

*/

#ifndef _AGENT_SET_H
#define _AGENT_SET_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _AGENT_AGENT_ID
#include "agentAgentId.h"	// AgentId
#endif



#include "agentId.h"
#include "suppHash.h"
#include "genMessage.h"
#include "servPointerList.h"	// PointerList
#include "genQueue.h"
#include "genSecurity.h"
#include "genUtility.h"

class IncomingBody;
class MonitorLock;
class ServerAgent;

    /* number of entries in the name and id hash tables */

const unsigned int Hash_ENTRIES    	= 0x0100;

    /* number of entries in the event hash table */

const unsigned int EVENT_Hash_ENTRIES	= 0x0080;
 
    /* pending events for a particular name or id */

struct PendingEvents
{
    PointerList birthNotifications;

	/* constructor and destructor */

    PendingEvents (void) {
	// empty
    }

   ~PendingEvents () {
	// empty
    }
};
 
  /* ServerAgent holds the data associated with an agent */
  
class ServerAgent 
{
    friend class AgentSet;

	/* back pointer to the AgentSet instance */

    AgentSet *agentSet;

	/* actual location of the agent plus the numeric id */
 
    AgentId id; 

	/* security information for the agent */

    BASE_SECURITY security;		// security information of the agent
    BASE_SECURITY creatorSecurity;	// security information for the agent's creator

	/* buffer for incoming messages, events and communication */

    IncomingBody *incomingBody;

	/* process id of the agent and process id of the background handler */

    UINT_32 pid;   
    UINT_32 handlerPid;

	/* number of pending status events that this agent has REQUESTED */
	/* and pointers to those events                                  */

    UINT_32 numPendingEvents;
    PointerList pendingBirthEvents;
         
	/* constructor and destructor */

    ServerAgent (AgentSet *set, char *server, UINT_32 ip, UINT_32 pid, const BASE_SECURITY &security);
   ~ServerAgent ();

	/* add an "exists" event to the event queue */

    void addExistsEvent (ServerAgent &newAgent);
};

  /* AgentSet holds the data for all agents */
               
class AgentSet
{
    friend class ServerAgent;

    unsigned numAgents;     // number of agents in the system            
    unsigned numAnonAgents; // number of anonymous agents in the system      
    INT_32 next_id;         // potential id for the next agent               
    Hash agent_table;       // hash table for agents                         
    Hash name_table;        // hash table for agent names                    
    Hash nameEventsTable;  // hash table for events triggered on agent names

	/* lookup the recipient agent */

     ServerAgent *lookupRecipient (UINT_32 id, char *name);  

	/* lookup the complete security information */

     BASE_SECURITY *lookupCompleteSecurity (BASE_SECURITY &security);
	
	/* lookup the actual id */ 

     AgentId *lookupActualId (AgentId *source, BASE_SECURITY &security);
 
public:
 
	/* constructor */

    AgentSet (void);

	/* associate a background connection with an agent */

    int setBackgroundConnection 
	(UINT_32 id, int sockfd, MonitorLock &monitor);


	/* handle begin, end, name, pid, messages, meetings, events */
	/* and information requests                                 */

    MESSAGE *agent_begin   (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_end     (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_event   (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_info    (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_ip      (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_name    (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_receive (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_req     (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_send    (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_status  (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_force   (MESSAGE *message, BASE_SECURITY &security);
    MESSAGE *agent_error   (MESSAGE *message, BASE_SECURITY &security);
};
     
#endif
