/* Agent Tcl
   Bob Gray
   25 February 1995

   agentd.h

   This file defines the data structures for the agent server.
   
   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _AGENTD_H
#define _AGENTD_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

    /*
     * forward declarations
     */

class AgentSet;
class ServerData;
class HotInterpreters;

    /* 
     * command line
     */

struct CommandLine 
{
	// command-line parameters

    char *configurationFile;	// name of the configuration file  
    char *hostname;		// host on which the agent server is running
    BOOLEAN daemon;         	// e_TRUE if running the process as a daemon 
    BOOLEAN verifyHostname;     // e_TRUE if we want to verify the hostname 
				// specified after the -host option
    BOOLEAN truncateLog;        // e_TRUE if we want to truncate the log file

	// command-line errors

    enum CommandLineError {
	e_CommandOk		  = 0,
	e_CommandMissingOption    = 1,
	e_CommandMissingParameter = 2,
	e_CommandInvalidOption    = 3
    };

	// constructors, assignment operator and destructor

    CommandLine (void);
    CommandLine (const CommandLine &);
    CommandLine& operator= (const CommandLine &);
   ~CommandLine ();

	// get the arguments specified on the program command line

    CommandLineError getArguments (int argc, char **argv);
};

    /* 
     * server and agent informaton
     */

extern ServerData *g_serverData;
extern AgentSet *agentSet;
extern CommandLine *g_commandLine;
extern HotInterpreters *hotInterpreters;

    /*
     * see if we have received a SIGHUP or a SIGIO
     */

int hasSighupFired (void);
int hasSigioFired (void);
void pretendSighupFired (void);
void pretendSigioFired (void);
int isSighupPending (void);
int isSigioPending (void);

    /*
     * handle SIGTERM, SIGIO, SIGHUP, SIGPROF and SIGCHL
     */

void sigterm_handler (int, SignalHandlers::ClientData);

#endif 
