/* Agent Tcl
   Bob Gray
   23 August 1995

   interp.cc

   This file implements the routines that keep track of available interpreters.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platDelete.h"
#include "interp.h"
#include "genUtility.h"

/*
 * constructors, assignment operator and destructor for INTERP
 */

INTERP::INTERP (void):
    m_name (),
    m_executable (),
    m_argv0 (),
    m_type (INTERP::e_NORMAL_INTERP),
    m_argv ((char **) NULL),
    m_argvReady (e_FALSE),
    m_minHotCount (e_DEFAULT_HOT_COUNT),
    m_maxHotCount (2 * e_DEFAULT_HOT_COUNT),
    m_agentsPerInterp (e_DEFAULT_AGENTS_PER_INTERP)
{
    // empty 
}

INTERP::INTERP (const INTERP &interp):
    m_name            (interp.m_name),
    m_executable      (interp.m_executable),
    m_argv0           (interp.m_argv0),
    m_arguments       (interp.m_arguments),
    m_type            (interp.m_type),
    m_argv            (NULL),
    m_argvReady       (e_FALSE),
    m_minHotCount     (interp.m_minHotCount),
    m_maxHotCount     (interp.m_maxHotCount),
    m_agentsPerInterp (interp.m_agentsPerInterp)
{
    // empty
}

INTERP::INTERP (DynamicString name, DynamicString executable, DynamicString argv0, INTERP::InterpreterTypes type, int minHotCount, int maxHotCount, int agentsPerInterp):
    m_name (name),
    m_executable (executable),
    m_argv0 (argv0),
    m_type (type),
    m_argv ((char **) NULL),
    m_argvReady (e_FALSE),
    m_minHotCount (minHotCount),
    m_maxHotCount (maxHotCount),
    m_agentsPerInterp (agentsPerInterp)
{
    // empty
}

INTERP &INTERP::operator= (const INTERP &interp)
{
    if (this != &interp) {
	m_name            = interp.m_name;
        m_executable      = interp.m_executable;
        m_argv0           = interp.m_argv0;
        m_arguments       = interp.m_arguments;
        m_type            = interp.m_type;
        m_argv            = NULL;
        m_argvReady       = e_FALSE;
	m_minHotCount     = interp.m_minHotCount;
	m_maxHotCount     = interp.m_maxHotCount;
	m_agentsPerInterp = interp.m_agentsPerInterp;
    }

    return (*this);
}

INTERP::~INTERP ()
{
    DELETE_ARRAY_OBJECT(m_argv);
}

/* INTERP::prepareArgv

   Purpose: Prepare the argv array
*/

void INTERP::prepareArgv (void)
{
	/* delete the old argv and allocate a new one of the correct size */

    DELETE_ARRAY_OBJECT(m_argv);
    m_argv = new char * [m_arguments.get_count() + 2];

	/* fill in the argv array */

    int i = 0;

    m_argv[i++] = m_argv0.value();

    for (int j = 0; j < m_arguments.get_count(); ++j) {
	m_argv[i++] = (m_arguments.peek(j)).value();
    }

    m_argv[i++] = (char *) NULL;
}
