/* Agent Tcl
   Bob Gray
   2 March 1998

   messageBuffers.h

   This file defines the class and thread 

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _MESSAGE_BUFFERS_H
#define _MESSAGE_BUFFERS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_EXCLUSION_H
#include "platExclusion.h"	// MonitorLock
#endif
#ifndef _PLAT_THREAD_H
#include "platThread.h"	// ThreadBody
#endif

class INCOMING_MESSAGE;
class INCOMING_EVENT;
class INCOMING_MEETING;
class IncomingBodyImp;

class IncomingTrap
{
public:

	// incoming meetings, messages or vents

    virtual void incomingMessage (INCOMING_MESSAGE *) = 0;
    virtual void incomingEvent	 (INCOMING_EVENT   *) = 0;
    virtual void incomingMeeting (INCOMING_MEETING *) = 0;

	// agent is done

    virtual void agentDone (void) = 0;
};

class IncomingBody: public ThreadBody, public IncomingTrap
{
    IncomingBodyImp *m_this;    // member data

public:

    	// constructors

    IncomingBody::IncomingBody (void);
    IncomingBody::IncomingBody (int sockfd, const MonitorLock &sigioMonitor);

	// make the background connection available

    void setBackgroundConnection (int sockfd, const MonitorLock &sigioMonitor);

	// callbacks

    void incomingMessage (INCOMING_MESSAGE *message);
    void incomingEvent	 (INCOMING_EVENT   *event);
    void incomingMeeting (INCOMING_MEETING *meeting);
    void agentDone       (void);

	// run the thread

    void run (void);

	// destructor

   ~IncomingBody ();
};

#endif
