/* Agent Tcl
   Bob Gray
   15 February 1995

   piped.cc

   This file implements "piped" which monitors the pipe from socketd to
   agentd.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platExclusion.h"
#include "platInterrupt.h"
#include "piped.h"
#include "agent_set.h"
#include "agentd.h"
#include "genError.h"
#include "genMessage.h"
#include "mesgTcpip.h"
#include "genTransmit.h"
#include "noise.h"
#include "random.h"
#include "randpool.h"
#include "servConf.h"

    /* maximum number of requests between stirs of the random pool */

const unsigned MAXIMUM_COUNTDOWN = 24;

    /* jump table for requests */

typedef MESSAGE * (AgentSet::*Action) (MESSAGE *, BASE_SECURITY &);

static Action jumpTable[NUM_REQUESTS] =
{
  &AgentSet::agent_begin,       /* REQ_BEGIN     */
  &AgentSet::agent_name,        /* REQ_NAME      */
  &AgentSet::agent_end,         /* REQ_END       */
  &AgentSet::agent_force,       /* REQ_FORCE     */
  NULL,                         /* REQ_SUBMIT    */
  &AgentSet::agent_send,        /* REQ_MESSAGE   */
  &AgentSet::agent_req,         /* REQ_MEETING   */
  &AgentSet::agent_event,       /* REQ_EVENT     */
  &AgentSet::agent_receive,     /* REQ_GET       */
  &AgentSet::agent_info,	/* REQ_INFO      */ 
  &AgentSet::agent_status,      /* REQ_STATUS    */
  &AgentSet::agent_ip,	    	/* REQ_IP        */
  NULL,				/* REQ_AUTH      */
  NULL,				/* REQ_SECURITY  */
  &AgentSet::agent_error	/* REQ_ERROR     */
};

/* piped

   Purpose: Map a message to the appropriate AgentSet method

     Input: None

    Output: The procedure returns the response message that should be sent to
            the agent.
*/

static MonitorLock *s_monitor = NULL;
static int s_randCountdown = 0;

MESSAGE *piped (MESSAGE &message, BASE_SECURITY &security)
{
    MESSAGE *response = NULL;

#ifdef FIX_LATER
	// we should move the initialization of the lock to avoid the race condition
#endif

    if (s_monitor == NULL) {
	s_monitor = new MonitorLock ();
    }

	/*
	 * mutual exclusion
	 */

    Guard guard (*s_monitor);

        /* 
	 * handle the message 
	 */
	
    UINT_8 flag = message.getFlag ();

    if (jumpTable[flag] == NULL) {
	g_serverData -> errorLog.error_app_quit 
	    ("piped: ERROR: REQ_SUBMIT, REQ_SECURITY and REQ_IP are not supported");
    }

    response = (agentSet->*jumpTable[flag]) (&message, security);

	/* 
	 * decrement the countdown and stir the random pool if countdown is at zero
	 */

#ifdef FIX_LATER

	/*
	 * add this back later
	 */

    if (s_randCountdown != 0) {

	s_randCountdown -= 1;

    } else {

	UINT_8 flagByte = ((response -> getFlag()) << 4) | (message.getFlag());
	noise ();
	randPoolAddBytes ((byte *) &flagByte, 1);
	s_randCountdown = ((unsigned) trueRandByte()) % MAXIMUM_COUNTDOWN + 1;
    }

#endif

    return (response);
}

/* piped_setBackgroundConnection

   Purpose: Tell the message-buffering thread for an agent which socket to
            send the messages down
*/

int piped_setBackgroundConnection (UINT_32 id, int sockfd, MonitorLock &monitor)
{
    Guard guard (*s_monitor);
    return (agentSet -> setBackgroundConnection (id, sockfd, monitor));
}
