/* Agent Tcl
   Bob Gray
   25 March 1997

   servPointerList.h

   This file defines a list of pointers that supports expected linear-time
   insertion and deletion (i.e., the list is implemented as a hash table).

   Copyright (c) 1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.

   RCS INFORMATION:

   $Id: servPointerList.h,v 1.1 1998/08/10 14:57:36 rgray Exp $

   $Log: servPointerList.h,v $
   Revision 1.1  1998/08/10 14:57:36  rgray
   Initial revision

   Revision 1.1  1997/10/17 06:02:11  rgray
   Initial revision

   Revision 1.1  1997/10/17 05:51:31  rgray
   Initial revision

   Revision 1.1  1997/10/17 05:43:42  rgray
   Initial revision

   Revision 1.5  1997/05/03 18:24:43  rgray
   fixed pragmas

 * Revision 1.4  1997/03/26  16:02:19  rgray
 * fixed runtime bug
 *
   Revision 1.3  1997/03/26 15:07:46  rgray
   server now users a PointerList for name events

   Revision 1.2  1997/03/25 22:53:05  rgray
   fixed compiler errors

   Revision 1.1  1997/03/25 22:44:21  rgray
   Initial revision

*/

#ifndef _SERV_POINTER_LIST_H
#define _SERV_POINTER_LIST_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

struct PointerNode
{
    char *m_pointer;	  // the pointer
    unsigned m_count;     // number of times the pointer appears in the "list"
    PointerNode *m_next;  // next node 

	// constructor

    PointerNode (char *pointer, PointerNode *next):
	m_pointer (pointer),
	m_count (1),
	m_next (next)
    {
	// empty
    }
};

class PointerList 
{
    friend class PointerIterator; 

    unsigned entries;      // number of pointers in the table
    unsigned maxIndex;     // maximum table index
    PointerNode **table;   // table

    inline long hash (char *pointer) {

	long key = 0;
	char *sp = (char *) pointer;

	for (unsigned i = 0; i < sizeof(char *); i++) {
	    key = (key << 3) + key + *sp;
	}

	key &= maxIndex;
	return (key);
    }

public:

	/* constructor and destructor */

    PointerList (void);
   ~PointerList ();

      /* get the number of pointers in the list */

    inline unsigned getPointerCount (void) { 
	return (entries); 
    } 

	/* insert and remove a pointer */

    void insert (char *pointer);
    int remove (char *pointer);
    int removeAll (char *pointer);

      /* empty out the list */

    void empty (void);
};

class PointerIterator
{
    PointerList *list;     // list associated with this iterator     
    unsigned bucket;       // current bucket of the table             
    PointerNode *node;     // current node of the table                
    unsigned instance;     // current instance of a duplicated pointer 

	/* unimplemented */

    PointerIterator (const PointerIterator &);
    PointerIterator& operator= (const PointerIterator &);

public:

	/* constructors */

    PointerIterator (PointerList *list);

	/* get the next pointer in the list */

    int nextPointer (char*& pointer);
    int nextDistinctPointer (char*& pointer);
};

#endif
