/* Agent Tcl
   Bob Gray
   9 February 1995

   servProcess.h

   This file defines the functions that the server uses to HANDLE a client
   request.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SERV_PROCESS_H
#define _SERV_PROCESS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif
#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif
#ifndef _PLAT_SIZES_H
#include "platSizes.h"		// UINT_8
#endif

    /* forward declarations */

class MESSAGE;
class BASE_SECURITY;
class MonitorLock;

    /* maximum sleep time when trying to send a result (seconds) */

const int MAXIMUM_SLEEP = 300; 
        
    /* handler error codes */

enum HandlerErrors {
    e_HANDLER_OK                = 0,
    e_HANDLER_BACKGROUND_ENDED  = 1,
    e_HANDLER_BACKGROUND_FAILED = 2,
    e_HANDLER_ERROR             = 3
};

    /* handle client requests */

int handleNewAgent
    (int sockfd, MonitorLock *sockfdLock, BASE_SECURITY &sender, MESSAGE *message, BOOLEAN background, struct timeval& timestamp);

int handleSend
    (int sockfd, MonitorLock *sockfdLock, BASE_SECURITY &sender, MESSAGE *message, BOOLEAN background, struct timeval& timestamp);

    /* send an error response */

void respondWithError 
    (int sockfd, MonitorLock *sockfdLock, UINT_8 code);

#endif
