/* Agent Tcl
   Bob Gray
   11 April 1997

   servRandom.h

   This file defines a class that controls access to a file of random bits.
*/

#ifndef _SERV_RANDOM_H
#define _SERV_RANDOM_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _GEN_DSTRING
#include "suppDString.h"		// DynamicString
#endif

class RandomFile
{
    DynamicString m_filename;	// name of the random bits file
    unsigned m_bits;		// number of bits of interest

public:

	/* error codes */

    enum RandomFileErrors {
	e_OK,			
	e_CANT_OPEN,	
	e_CANT_WRITE
    };

	/* constructors */

    RandomFile (const DynamicString &filename, unsigned m_bits);

	/* burn the random bits -- e.g. overwrite them with new random bits */

    RandomFile::RandomFileErrors burnBits (void);
};

#endif
