/* Agent Tcl
   Bob Gray
   9 February 1995

   socketed.h

   This file defines "socketd" which monitors the TCP/IP port.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SERVER_H
#define _SERVER_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _TRUEFALSE_H
#include "truefalse.h"
#endif

  /* forward declarations */

class ShortMutexLock;
class MonitorLock;

  /* socket watcher */

class Socketd
{
public:

	// watch the sockets and handle incoming requests

    static void socketd (void);

	// tell socketd that one of the handler threads is going to become a 
	// background thread

    static void handlerBecomesBackground (BOOLEAN isUnixSocket);

	// tell socketd that one of the background threads is done and is
	// going to become a handler thread once again -- The method
	// returns e_FALSE if there are too many handler threads and the
	// background thread should just die (rather than becoming a
	// handler thread again).

    static BOOLEAN backgroundBecomesHandler (BOOLEAN isUnixSocket);

private:

	// minimum and maximum numbers of handler threads

#ifdef FIX_LATER
	// we should have a pool of handler threads that dynamically shrinks
	// and grows according to the current load
#endif

    static const int c_minimumUnixHandlers  = 4;
    static const int c_minimumTcpipHandlers = 4;
    static const int c_maximumUnixHandlers  = 8;
    static const int c_maximumTcpipHandlers = 8;

	// current number of handler threads

    static int m_unixHandlers;
    static int m_tcpipHandlers;

	// "short-section" mutex lock to protect m_unixHandlers and 
	// m_tcpipHandlers

    static ShortMutexLock *m_countLock;

	// m_monitor is signaled when socketd needs to create another handler

    static MonitorLock *m_monitor;
};
      
#endif
