/* Agent Tcl
   Bob Gray
   23 November 1996

   genrand.cc

   This file implements a utility that is used to generate a file of random
   bits.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "platPorting.h"
#include "random.h"

const int MINIMUM_BITS = 512;
const int DEFAULT_BITS = 3072;

int main (int argc, char **argv)
{
    FILE *fp;
    int randomBits;

	// make sure that we have the right number of arguments

    if ((argc != 2) && (argc != 3)) {
	fprintf (stderr, "\nUSAGE:\n\n%s <filename> [bits]\n\n", argv[0]);
	exit (1);
    }

	// get the number of random bits

    if (argc == 2) {

	randomBits = DEFAULT_BITS;

    } else {

	if (sscanf (argv[2], "%d", &randomBits) < 1) {
	    fprintf (stderr, "\nERROR: number of bits must be an integer!\n\n");
	    exit (1);
	}

	if (randomBits < MINIMUM_BITS) {
	    fprintf (stderr, "\nERROR: number of bits must be %d or greater\n\n", MINIMUM_BITS);
	    exit (1);
	}
    }

    if (randomBits % 8 != 0) { 
	randomBits = (randomBits / 8) + 8;
    }

	// open the file for writing 

    if ((fp = fopen (argv[1], "w")) == NULL) {
	fprintf (stderr, "\nERROR: unable to open file \"%s\"\n\n", argv[1]);
	exit (1);
    }

    if (chmod (argv[1], 0600) < 0) {
	fprintf (stderr, "\nERROR: unable to change file \"%s\" to user-readable only!\n\n", argv[1]);
	exit (1);
    }

	// ask the user for the random bits

    trueRandAccum (randomBits); 

	// get the random bytes for the file

    char *buffer = new char [randomBits / 8];

    for (int i = 0; i < randomBits / 8; i++) {
	buffer[i] = trueRandByte ();
    }

    fwrite (buffer, sizeof(char), randomBits / 8, fp);
  
	// done

    fclose (fp);
    fprintf (stderr, "\nDONE: file \"%s\" has been filled with %d random bits!\n\n", argv[1], randomBits);
    exit (0);
}
