/* Agent Tcl
   Bob Gray
   17 February 1997

   seerand.cc

   This file implements a utility that is used to see the contents of a 
   random bits file.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "platPorting.h"
#include "random.h"

int main (int argc, char **argv)
{
    int fd;

	// make sure that we have the right number of arguments

    if (argc != 2) {
	fprintf (stderr, "\nUSAGE:\n\n%s <filename>\n\n", argv[0]);
	exit (1);
    }

	// open the file for reading

    if ((fd = open (argv[1], O_RDONLY)) < 0) {
	fprintf (stderr, "\nERROR: unable to open file \"%s\"\n\n", argv[1]);
	exit (1);
    }

	// read the random bits one a time

    char c;
    unsigned n;
    int bytesOutput = 0;

    while (read (fd, &c, 1) > 0) {

	n = (unsigned char) c;

	printf ("%02x ", n);

	if (++bytesOutput % 20 == 0) {
	   printf ("\n");
	}
   }

   printf ("\n");

	// done

   close (fd); 
}
