/* Agent Tcl
   Bob Gray
   17 February 1997

   seerand.cc

   This file implements a utility that is used to see the contents of a 
   random bits file.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "platPorting.h"
#include "random.h"
#include "noise.h"
#include "randpool.h"

int main (int argc, char **argv)
{
    int fd;

	// make sure that we have the right number of arguments

    if (argc != 2) {
	fprintf (stderr, "\nUSAGE:\n\n%s <filename>\n\n", argv[0]);
	exit (1);
    }

	// open the file for reading

    if ((fd = open (argv[1], O_RDONLY)) < 0) {
	fprintf (stderr, "\nERROR: unable to open file \"%s\"\n\n", argv[1]);
	exit (1);
    }

	// read the random bits one a time

    char randomByte;
    int numBytes = 0;

    (void) noise ();   // not much entropy but some

    while (read (fd, &randomByte, 1) > 0) {
	numBytes += 1;
	randPoolAddBytes ((byte *) &randomByte, 1);
    }

    close (fd);

    (void) noise ();   // not much entropy but some

	// stir in everything on standard input

    while (read (0, &randomByte, 0) > 0) {
	randPoolAddBytes ((byte *) &randomByte, 1);
    }

    (void) noise ();   // not much entropy but some

	// write out as many random bytes as we read in

    char *buffer = new char [numBytes];

    for (int i = 0; i < numBytes; i++) { 
	buffer[i] = trueRandByte();
    }

    if ((fd = open (argv[1], O_WRONLY)) < 0) {
	fprintf (stderr, "\nERROR: unable to open file \"%s\"\n\n", argv[1]);
	exit (1);
    }

    if (write (fd, buffer, numBytes) < numBytes) {
	fprintf (stderr, "\nERROR: unable to write to file \"%s\"\n\n", argv[1]);
	close (fd);
	return -1;
    }

    close (fd);

	// done 

    fprintf (stderr, "\nDONE: random file \"%s\" has been stirred!\n\n", argv[1]);

}
