/* Agent Tcl
   Bob Gray
   25 February 1995

   agentd.h

   This file defines the data structures for the agent server.
   
   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _AGENTD_H
#define _AGENTD_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

    /*
     * forward declarations
     */

class AgentSet;
class ServerData;

    /* 
     * command line
     */

struct CommandLine 
{
    char *configurationFile;	// name of the configuration file         
    BOOLEAN daemon;         	// e_TRUE if running the process as a daemon 
    BOOLEAN verifyHostname;     // e_TRUE if we want to verify the hostname specified after the -host option
    BOOLEAN truncateLog;        // e_TRUE if we want to truncate the log file
};

    /* 
     * server and agent informaton
     */

extern ServerData *serverData;
extern AgentSet *agentSet;
extern CommandLine *commandLine;

    /*
     * see if we have received a SIGHUP or a SIGIO
     */

int hasSighupFired (void);
int hasSigioFired (void);
void pretendSighupFired (void);
void pretendSigioFired (void);
int isSighupPending (void);
int isSigioPending (void);

    /*
     * handle SIGTERM, SIGIO, SIGHUP, SIGPROF and SIGCHL
     */

void sigterm_handler (int, SignalHandlers::ClientData);

#endif 
