/* Agent Tcl
   Bob Gray
   23 August 1995

   interp.cc

   This file implements the routines that keep track of available interpreters.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "interp.h"
#include "genUtility.h"

/* INTERP::INTERP and INTERP::~INTERP

   Purpose: These procedures are the constructors and destructor for struct
            INTERP.  
*/

INTERP::INTERP (void):
    m_name (),
    m_executable (),
    m_argv0 (),
    m_type (INTERP::e_NORMAL_INTERP),
    m_argv ((char **) NULL),
    m_argvReady (e_FALSE)
{
    // empty 
}

INTERP::INTERP (DynamicString name, DynamicString executable, DynamicString argv0, INTERP::InterpreterTypes type):
    m_name (name),
    m_executable (executable),
    m_argv0 (argv0),
    m_type (type),
    m_argv ((char **) NULL),
    m_argvReady (e_FALSE)
{
    // empty
}

INTERP::~INTERP ()
{
    delete (m_argv);
}

/* INTERP::prepareArgv

   Purpose: Prepare the argv array
*/

void INTERP::prepareArgv (void)
{
	/* delete the old argv and allocate a new one of the correct size */

    delete (m_argv);
    m_argv = new char * [m_arguments.get_count() + 2];

	/* fill in the argv array */

    int i = 0;

    m_argv[i++] = m_argv0.value();

    for (int j = 0; j < m_arguments.get_count(); ++j) {
	m_argv[i++] = (m_arguments.peek(j)).value();
    }

    m_argv[i++] = (char *) NULL;
}
