/* Agent Tcl
   Bob Gray
   23 August 1995

   interp.h

   This file defines the routines that keep track of available interpreters.
*/

#ifndef _INTERP_H
#define _INTERP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _SUPP_DSTRING_H
#include "suppDString.h"		// DynamicString
#endif
#ifndef _SUPP_DSTRING_QUEUE_H
#include "genDStringQueue.h"	// DynamicStringQueue
#endif

  /* struct INTERP holds the information on one interpreter */

class INTERP
{
public:

    enum InterpreterTypes {
	e_STATE_INTERP  = 0,		/* accepts state images */
	e_NORMAL_INTERP = 1		/* accepts scripts only */
    };

private:

    DynamicString m_name;           /* symbolic name for the interpreter           */
    DynamicString m_executable;     /* executable file that starts the interpreter */
    DynamicString m_argv0;          /* argv[0] that is passed to the executable    */
    DynamicStringQueue m_arguments; /* arguments to pass to the interpreter        */
    InterpreterTypes m_type;        /* e_STATE_INTERP or e_NORMAL_INTERP           */
    char **m_argv;		    /* argv array for an execve call               */
    BOOLEAN m_argvReady;            /* e_TRUE if the argv array is up-to-date      */

private:

	/* fill in the argv array */

    void prepareArgv (void);

public:

	/* constructors */

    INTERP (void);
    INTERP (DynamicString name, DynamicString executable, DynamicString argv0, InterpreterTypes type);
    INTERP (const INTERP &interp);

	/* assignment operator */

    INTERP &operator= (const INTERP &interp);

	/* symbolic name, executable, argv0 and type */

    DynamicString getName (void) const {
	return (m_name);
    }

    DynamicString getExecutable (void) const {
	return (m_executable);
    }

    DynamicString getArgv0 (void) const {
	return (m_argv0);
    }

    InterpreterTypes getType (void) const {
	return (m_type);
    }

    void setName (DynamicString name) {
	m_name = name;
    }

    void setExecutable (DynamicString executable) {
	m_executable = executable;
    }

    void setArgv0 (DynamicString argv0) {
	m_argv0 = argv0;
    }

    void setType (InterpreterTypes type) {
	m_type = type;
    }

	/* access the arguments */

    int getArgumentCount (void) const {
	return (m_arguments.get_count());
    }

    DynamicString getArgument (int i) const {
	return (m_arguments.peek(i));
    }

    void addArgument (DynamicString arg) {
	m_arguments.enqueue (arg);
	m_argvReady = e_FALSE;
    }

	/* access argv */

    char **getArgv (void) {
	
	if (!m_argvReady) {
	    prepareArgv ();
	}

	return (m_argv);
    }
	
	/* destructor */

   ~INTERP ();
};

#endif
