/* Agent Tcl
   Bob Gray
   23 August 1995

   parse.h

   This file defines the parsing routines.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PARSE_H
#define _PARSE_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include <stdio.h>

#ifdef FIX_LATER
// Need to define parser error codes
#endif

class DynamicString;

class PARSE
{
   FILE *fp;        /* file that is being parsed */
   int ch;          /* current character         */
   int size;        /* maximum word length       */
   char *buffer;    /* buffer to hold a word     */
   int line;        /* line number               */

      /* skip over a comment */

   void skip_comment (void);

  public:

        /* constructor */

    PARSE (FILE *fp, int size);
   ~PARSE ();

        /* get the next word */

    int getNextWord (char *&buffer_ptr);
    int getNextLine (int maxWords, DynamicString *wordBuffer, int& wordCount);

	/* get the current line number */

    int getLineNumber (void) {
	return (line);
    }
};

#endif
