/* Bob Gray
   Agent Tcl
   27 January 1996

   servConf.h

   This file defines the routines that load the server configuration files.

   Copyright (c) 1995-1997, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SERV_CONF_H
#define _SERV_CONF_H

#ifndef NO_PRAGMAS
#pragma interface
#endif 

#ifndef _SUPP_MACH_ID_H
#include "mesgMachId.h"	   // class MachineId
#endif
#ifndef _AGENT_PERMIT_H
#include "agentPermit.h"	   // class Permit
#endif
#ifndef _AGENT_SECURE_H
#include "agentSecure.h"	   // class BASE_SECURITY
#endif
#ifndef _SUPP_DSTRING_H
#include "suppDString.h"		   // class DynamicString
#endif
#ifndef _GEN_ERROR_H
#include "genError.h"		   // class ERROR
#endif
#ifndef _SUPP_HASH_H
#include "suppHash.h"		   // class Hash
#endif
#ifndef _GEN_QUEUE_H
#include "genQueue.h"		   // QUEUE
#endif
#ifndef _PLAT_SIZES_H
#include "platSizes.h"		   // UINT_32
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		   // BOOLEAN
#endif

    // forward declarations 

class CommandLine;

    // machine for which we need to get the IP address

class DeferredIp
{
public:

    enum DeferredType {
	e_TRUSTED_MACHINE = 0,
	e_ALLOWED_MACHINE = 1
    };

private:

    DynamicString m_machine;	// machine name
    DeferredType m_type;	// e_TRUSTED_MACHINE or e_ALLOWED_MACHINE

public:
	
	    // constructor and destructor

    DeferredIp (DynamicString machine, DeferredType type):
	m_machine (machine),
	m_type (type)
    {
	// empty 
    }

   ~DeferredIp () {
	// empty
    }

	    // access

    DeferredType getType (void) const {
	return (m_type);
    }

    DynamicString getMachine (void) const {
	return (m_machine);
    }
};

    // server data

struct ServerData 
{
	// who is reloading the configuration

    enum ReloadLocation {
        e_RELOADING_IN_AGENTD,
        e_RELOADING_IN_SOCKETD,
        e_RELOADING_IN_HANDLER,
        e_INITIAL_LOAD
    };

	// configuration-file options 

    DynamicString userName;          // userid under which to run the server
    DynamicString groupName;         // group name under which to run the server
    BOOLEAN encryption;              // TRUE if an encryption subsytem is available
    UINT_32 maxAgents;               // maximum number of agents
    UINT_32 maxAnonAgents;           // maximum number of *anonymous* agents 
    UINT_32 maxStatus;               // maximum number of notification events per agent
    UINT_32 extraProcesses;          // number of extra processes for non-creation requests
    BOOLEAN remoteBegin;             // TRUE if agents can register from remote mach.
    BOOLEAN remoteComm;	             // TRUE if agents can communicate from remote mach.
    BOOLEAN remoteForce;             // TRUE if agents can force from remote mach.
    BOOLEAN remoteInfo;	             // TRUE if agents can get info from remote mach.
    DynamicString ownerKeyname;      // keyname of the machine owner
    DynamicString adminKeyname;      // keyname of the server administrator
    BOOLEAN allowSigned;             // TRUE to allow signed agents from arbitrary machines
    Hash machineTable;               // IP addresses of the AllowedMachine's
    Hash userTable;                  // keynames of the AllowedUser's
    Hash trustedTable;               // keynames of the TrustedMachine's
    Hash reservedTable;              // reserved agent names 
    DynamicString socketFilename;    // name of the unix domain socket
    UINT_32 socketPort;    	     // port of the TCP/IP socket
    DynamicString logFilename;	     // filename of the log file
    DynamicString lockFilename;	     // filename of the lock file
    DynamicString interpFilename;    // filename of the interpreter filename
    DynamicString pidFilename;       // filename in which to write server process id
    DynamicString passPhrase;        // server pass phrase
    UINT_32 randomBits;	             // number of required random bits
    DynamicString randomFilename;    // name of the random bits file
    DynamicString pgpProgname;	     // pathname of the PGP executable
    DynamicString pgpPathname;	     // pathname of the PGP key directory 
    Hash interpTable;                // available interpreters 
    Permit authorizedPermit;	     // initial resource permit for *authorized* agents
    Permit anonymousPermit;	     // initial resource permit for *anonymous* agents
    DynamicString tempDirectory;     // temporary directory for agent-specific files
    DynamicString coredumpDirectory; // directory for core dumps

	// other data structures

    QUEUE deferredIps;		   // machines whose IP addresses we need to find	
    ERROR errorLog;	           // log for errors and informational messages
    int sockfd;		           // TCP/IP socket for remote requests
    int unixSockfd;                // Unix domain socket for local requests
    int lockfd;                    // file descriptor of the lock file 
    int streamSocketd;             // stream pipe to/from socketd   
    int streamAgentd;              // stream pipe to/from agentd     
    BASE_SECURITY security;        // security information about the server   
    MachineId host;                // name and IP address of the server's host 
    int socketdPid;                // process id of socketd                   
    int agentdPid;                 // process id of agentd                     
    UINT_32 socketdChildren;       // number of children of socketd
    char **agentEnviron; 	   // environ array for the intrepreters
    int connectionEnvSlot;         // reserved slot in agentEnviron for the CONNECTION environment variable
    DynamicString pgpPathEnv;      // environ entry that specifies PGP path
    DynamicString pgpProgEnv;      // environ entry that specifies PGP executable
 
	// constructor and destructor

    ServerData (void);
   ~ServerData (void);

	// empty out the server data

    void empty (void);

	// resolve all IP addresses

    void resolveIp (ReloadLocation reloadLocation);

	// load the configuration data

    int load (const CommandLine &commandLine, ReloadLocation reloadLocation);

private:

	// prevent copies and assignment

    ServerData (const ServerData&);
    ServerData& operator= (const ServerData&);
};  


#endif
