/* Agent Tcl
   Bob Gray
   9 February 1995

   servProcess.h

   This file defines the functions that the server uses to HANDLE a client
   request.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SERV_PROCESS_H
#define _SERV_PROCESS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif
#ifndef _PLAT_INTERRUPT_H
#include "platInterrupt.h"
#endif
#ifndef _PLAT_SIZES_H
#include "platSizes.h"		// UINT_8
#endif

    /* forward declarations */

class MESSAGE;
class BASE_SECURITY;
class NewBackgroundHandler;

    /* maximum sleep time when trying to send a result (seconds) */

const int MAXIMUM_SLEEP = 300; 
         
    /* handle client requests */

int handleNewAgent
    (int sockfd, BASE_SECURITY &sender, MESSAGE *message, BOOLEAN background, NewBackgroundHandler*& newHandler);

int handleSend
    (int sockfd, BASE_SECURITY &sender, MESSAGE *message, BOOLEAN background, NewBackgroundHandler*& newHandler);

    /* make a background connection */

int backgroundConnection (
	BASE_SECURITY &sender, 
	NewBackgroundHandler &handler, 
	NewBackgroundHandler *&newHandler
    );

    /* send an error response */

void respondWithError 
    (int sockfd, UINT_8 code);

    /* SIGIO, SIGALRM, SIGUSR handlers -- these routines are used only in */
    /* conjunction with the procedures and data inside servProcess.cc --  */
    /* they are defined externally so that they can be installed once in  */
    /* socketd.cc rather than over and over again in servProcess.cc --    */
    /* in other words socketd installs the handlers and the children of   */
    /* socketd inherit and use these handlers                             */
 
void sigusr1_handler 
    (int signo, SignalHandlers::ClientData);
 
void sigusr2_handler 
    (int signo, SignalHandlers::ClientData);

void sigio_handler 
    (int signo, SignalHandlers::ClientData);

void sigalrm_handler
    (int signo, SignalHandlers::ClientData);
 
#endif
