/* Agent Tcl
   Bob Gray
   9 February 1995

   servReceive.h

   This file defines the routines that the server uses to RECEIVE a
   request.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/
 
#ifndef _SERV_RECEIVE_H
#define _SERV_RECEIVE_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H		// pid_t
#include "platPorting.h"
#endif
#ifndef _AgentId_H
#include "agentAgentId.h"	// AgentId
#endif
#ifndef _PLAT_SIZES_H
#include "platSizes.h"		// UINT_32
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

    /* forward declarations */

class MESSAGE;
class BASE_SECURITY;

    /* when one agent submits another agent to the same machine,       */
    /* the background handler must fork into two background handlers,  */
    /* one for the existing agent and one for the new agent -- the     */
    /* NewBackgroundHandler specifies all of the information needed to */
    /* set up the new background handler                               */

struct NewBackgroundHandler
{
    AgentId localId;   // local id of the new agent
    AgentId rootId;    // root id of the new agent
    int sockfd;		// sockfd of the new agent's background handler
    pid_t pid;          // process id of the associated agent
};

    /* handle an agent request arriving on a TCP/IP connection */

int handleClientRequest 
    (int sockfd, BOOLEAN isUnixSocket);

    /* handle an agent request arriving on the agent's background connection */

int handleBackgroundClientRequest
    (int sockfd, MESSAGE *message, BASE_SECURITY& sender, NewBackgroundHandler*& handler);

#endif
