/* Agent Tcl
   Bob Gray
   4 August 1998

   suppBinary.cc

   This file implements a set of classes for working with binary data.

   Copyright (c) 1995-1998, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platExclusion.h"
#include "suppBinary.h"
#include "suppBinaryImp.h"
#include "suppReferenceCount.h"

    // static variables

BinaryDataStructureImp *BinaryDataStructure::m_emptyStructure 
	= NULL;

    // constructors, assignment operator and destructor

BinaryDataStructure::BinaryDataStructure (const BinaryDataStructure &structure):
    m_imp (structure.m_imp)
{
    m_imp -> Grab();
}

BinaryDataStructure& BinaryDataStructure::operator= (const BinaryDataStructure &structure)
{
    if ((this != &structure) && (m_imp != structure.m_imp)) {
	structure.m_imp -> Grab();
	m_imp -> Release();
	m_imp = structure.m_imp;
    }

    return (*this);
}

BinaryDataStructure::~BinaryDataStructure () 
{
    m_imp -> Release();
}

void BinaryDataStructure::copyOnWrite (void)
{
    BinaryDataStructureImp *newImp = new BinaryDataStructureImp (*m_imp);
    newImp -> GrabWithoutLock();
    m_imp -> Release();
    m_imp = newImp;
}

void BinaryDataStructure::addIntegerField (UINT_32 value)
{
    if (m_imp -> checkReferenceCount() > 1) {
	copyOnWrite();
    }

    m_imp -> addIntegerValue (value);
}

BinaryDataImp *BinaryDataStructure::getImplementationInstance (void) const {
    return (m_imp);
}

    // initialize the static data

class EmptyStructureInitializer: public OnceTrap
{
public:

    EmptyStructureInitializer (BinaryDataStructureImp *&emptyStructure):
	m_emptyStructure (emptyStructure) 
    {
	// empty
    }

    void initialize (void) {
	m_emptyStructure = new BinaryDataStructureImp();
	m_emptyStructure -> GrabWithoutLock();
    }

private:

    BinaryDataStructureImp *&m_emptyStructure;
};

void BinaryDataStructure::createEmptyStructure (void)
{
    static MonitorOnce::OnceControl onceControl = MonitorOnce::e_NEVER;

    if (onceControl != MonitorOnce::e_DONE) {
	EmptyStructureInitializer initializer (m_emptyStructure);
	MonitorOnce::doOnce (onceControl, initializer);
    }
}
