/* Agent Tcl
   Bob Gray
   4 August 1998

   suppBinary.h

   This file defines a set of classes for working with binary data.

   Copyright (c) 1995-1998, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SUPP_BINARY_H
#define _SUPP_BINARY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

/*
 * NOTE:
 *
 * We include suppBinaryDataImp.h since we are interested in efficiency
 * rather than abstraction hiding at this level (i.e., we want inline
 * functions).  The real purpose of BinaryDataImp is to (1) make BinaryData
 * small enough to allocate on the stack and (2) give us something to
 * reference count to avoid memory allocation.
 */

#ifndef _PLAT_SIZES_H
#include "platSizes.h"
#endif
#ifndef _SUPP_REFERENCE_COUNT_H
#include "suppReferenceCount.h"
#endif
#ifndef _SUPP_BINARY_IMP_H
#include "suppBinaryImp.h"
#endif
#ifndef _SUPP_BINARY_TYPES_H
#include "suppBinaryTypes.h"
#endif

    // forward declarations

class BinaryDataImp;
class BinaryDataStructureImp;

    // binary data

class BinaryData
{
    friend class BinaryTable;

public:

	// get the base type

    virtual BinaryDataTypes getType (void) const = 0;

	// destructor

    virtual ~BinaryData () {
	// empty
    }

private:

	// get the implementation instance (called from BinaryTable)

    virtual BinaryDataImp *getImplementationInstance (void) const = 0;
};

    // binary data structure

class BinaryDataStructure: public BinaryData
{
    friend class BinaryTable;

public:

	// constructors, assignment operator and destructor

    BinaryDataStructure (void) {

	if (m_emptyStructure == NULL) {
	    createEmptyStructure ();
	}

	m_imp = m_emptyStructure;
	m_imp -> Grab();
    }

    BinaryDataStructure (const BinaryDataStructure &);
    BinaryDataStructure &operator= (const BinaryDataStructure &);
    virtual ~BinaryDataStructure ();

	// get the type

    BinaryDataTypes getType (void) const {
	return (e_BinaryStructure);
    }

	// add and access fields

    void addIntegerField (UINT_32 value);

private:

	// copy-on-write

    void copyOnWrite (void);

	// create the empty structure

    void createEmptyStructure (void);

	// empty structure

    static BinaryDataStructureImp *m_emptyStructure;

	// get the implementation details (called from BinaryTable)

    BinaryDataImp *getImplementationInstance (void) const;

	// implementation details

    BinaryDataStructureImp *m_imp;
};

#endif
