/* Agent Tcl
   Bob Gray
   4 August 1998

   suppBinaryImp.cc

   This file implements the implementation classes corresponding to the
   abstract hierarchy in suppBinary.h.

   Copyright (c) 1995-1998, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platDelete.h"
#include "suppBinary.h"
#include "suppBinaryImp.h"
#include "suppReferenceCount.h"

    // constructors and destructor

BinaryDataStructureImp::BinaryDataStructureImp (void):
    BinaryDataImp (),
    m_numSlots (e_INITIAL_FIELDS),
    m_numFields (0),
    m_fieldsPtr (m_fields)
{
    // empty
}

BinaryDataStructureImp::BinaryDataStructureImp (const BinaryDataStructureImp &structureImp):
    BinaryDataImp (structureImp),
    m_numSlots (structureImp.m_numSlots),
    m_numFields (structureImp.m_numFields)
{
	// set up field array

    if (m_numFields < e_INITIAL_FIELDS) {
	m_fieldsPtr = m_fields;
    } else {
	m_fieldsPtr = new Field [m_numSlots];
    }

	// copy fields

    copyFields (m_fieldsPtr, structureImp.m_fieldsPtr, m_numFields, e_Grab);
}

BinaryDataStructureImp &BinaryDataStructureImp::operator= (const BinaryDataStructureImp &structureImp) 
{
    if (this != &structureImp) {

	BinaryDataImp::operator= (structureImp);

	deleteFields();

	if (structureImp.m_numFields > m_numSlots) {
	    DELETE_ARRAY_OBJECT(m_fieldsPtr);
	    m_fieldsPtr = new Field [structureImp.m_numSlots];
	}

	m_numFields = structureImp.m_numFields;
	m_numSlots  = structureImp.m_numSlots;
	copyFields (m_fieldsPtr, structureImp.m_fieldsPtr, m_numFields, e_Grab);
    }

    return (*this);
}

BinaryDataStructureImp::~BinaryDataStructureImp () 
{
    deleteFields();

    if (m_fieldsPtr != m_fields) {
	DELETE_ARRAY_OBJECT(m_fieldsPtr);
    }
}

    // add and access fields

void BinaryDataStructureImp::addIntegerValue (UINT_32 value) 
{
    if (m_numFields == m_numSlots) {
	expandFields();
    }

    m_fieldsPtr[m_numFields].m_type                 = e_BinaryInteger;
    m_fieldsPtr[m_numFields].m_value.m_integerValue = value;

    m_numFields += 1;
}

    // get the type descriptor size and the type descriptor

int BinaryDataStructureImp::getTypeDescriptorSize (void) 
{
    int size = 0;

    return (size);
}

char *BinaryDataStructureImp::getTypeDescriptor (char *bp) 
{

    return (bp);
}

    // expand the field array

void BinaryDataStructureImp::expandFields (void)
{
    int newSlots;
    Field *newFields;

    newSlots  = 2 * m_numSlots;
    newFields = new Field [newSlots];
    copyFields (newFields, m_fieldsPtr, m_numFields, e_NoGrab);

    if (m_fieldsPtr != m_fields) {
	DELETE_ARRAY_OBJECT(m_fieldsPtr);
    }

    m_fieldsPtr = newFields;
    m_numSlots  = newSlots;
}

    // delete the fields

void BinaryDataStructureImp::deleteFields (void) 
{
    for (int i = 0; i < m_numFields; ++i) {
	if (m_fieldsPtr[i].m_type == e_BinaryStructure) {
	    m_fieldsPtr[i].m_value.m_binaryValue -> Release();
	}
    }
}

    // copy fields

void BinaryDataStructureImp::copyFields (Field *toFields, Field *fromFields, int n, GrabType grabType) 
{
    for (int i = 0; i < n; ++i) {

	toFields[i].m_type = fromFields[i].m_type;

	switch (toFields[i].m_type) {

	    case e_BinaryInteger:

		toFields[i].m_value.m_integerValue = 
		    fromFields[i].m_value.m_integerValue;

		break;

	    case e_BinaryStructure:

		toFields[i].m_value.m_binaryValue = 
		    fromFields[i].m_value.m_binaryValue;

		if (grabType == e_Grab) {
		    toFields[i].m_value.m_binaryValue -> Grab();
		}

		break;
	}
    }
}
