/* Agent Tcl
   Bob Gray
   4 August 1998

   suppBinaryImp.h

   This file defines the implementation classes corresponding to the
   abstract hierarchy in suppBinary.h.

   Copyright (c) 1995-1998, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SUPP_BINARY_IMP_H
#define _SUPP_BINARY_IMP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_SIZES_H
#include "platSizes.h"
#endif
#ifndef _SUPP_REFERENCE_COUNT
#include "suppReferenceCount.h"
#endif
#ifndef _SUPP_BINARY_TYPES_H
#include "suppBinaryTypes.h"
#endif

    // binary data implementation

class BinaryDataImp: public ReferenceCount
{
public:

	// constructors, assignment operator and destructor

    BinaryDataImp (void):
	ReferenceCount ()
    {
	// empty
    }

    BinaryDataImp (const BinaryDataImp &imp):
	ReferenceCount (imp)
    {
	// empty
    }

    BinaryDataImp &operator= (const BinaryDataImp &imp) {

	if (this != &imp) {
	    ReferenceCount::operator= (imp);
	}

	return (*this);
    }

    virtual ~BinaryDataImp () {
	// empty
    }

	// get the type, the type descriptor size and the type descriptor itself

    virtual BinaryDataTypes getType (void) const = 0;
    virtual int getTypeDescriptorSize (void) = 0;
    virtual char *getTypeDescriptor (char *bp) = 0;
};

	// binary data structure implementation

class BinaryDataStructureImp;

union FieldValue {
    UINT_32 m_integerValue;			// integer value
    BinaryDataStructureImp *m_binaryValue;	// structure value
};

struct Field {
    BinaryDataTypes m_type;			// field type
    FieldValue m_value;				// field value
};

class BinaryDataStructureImp: public BinaryDataImp
{
private:

    enum InitialFields {
	e_INITIAL_FIELDS = 4
    };
   
    enum GrabType {
	e_Grab,
	e_NoGrab
    };
 
public:

	// constructors, assignment operator and destructor

    BinaryDataStructureImp (void);
    BinaryDataStructureImp (const BinaryDataStructureImp &structureImp);
    BinaryDataStructureImp &operator= (const BinaryDataStructureImp &structureImp);
   ~BinaryDataStructureImp ();

	// add and access fields

    void addIntegerValue (UINT_32 value);

	// get the type

    BinaryDataTypes getType (void) const {
	return (e_BinaryStructure);
    }

	// get the type descriptor size and the type descriptor
    
    int getTypeDescriptorSize (void);
    char *getTypeDescriptor (char *bp);

private:

	// expand the field array, delete fields and copy fields

    void expandFields (void);
    void deleteFields (void);
    void copyFields (Field *toFields, Field *fromFields, int n, GrabType grabType);

	// member data

    int m_numSlots;			// number of slots currently allocated for fields
    int m_numFields;			// number of fields
    Field m_fields[e_INITIAL_FIELDS];	// static field array for when we have a small number of fields
    Field *m_fieldsPtr;                 // pointer to the actual field array
};

#endif
