/* Agent Tcl
   Bob Gray
   5 August 1998

   suppBinaryTable.cc

   This file implements class BinaryTable, which maps handles to BinaryData
   instances.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "suppBinary.h"
#include "suppBinaryImp.h"
#include "suppBinaryTable.h"

const int c_TABLE_ENTRIES = 0x10;

BinaryTable::BinaryTable (void):
    m_table (c_TABLE_ENTRIES),
    m_nextHandle (0)
{
    // empty
}

BinaryTable::~BinaryTable ()
{
    HashNode *node;
    BinaryDataImp *binaryDataImp;

    HashSearch search (&m_table);

    while ((node = search.next ()) != NULL) {
	binaryDataImp = ((BinaryDataImp *) node -> data);
	binaryDataImp -> Release();
    }
}

UINT_32 BinaryTable::add (const BinaryData &binaryData)
{
    int there;
    UINT_32 handle;

	// extract the internal implementation instance and Grab it since
	// we are adding it to the table

    BinaryDataImp *binaryDataImp =
	binaryData.getImplementationInstance ();
    binaryDataImp -> Grab();

	// add the binary data to the hash table

    do {
	handle = m_nextHandle++;
	m_table.add (handle, NULL, (void *) binaryDataImp, there);
    } while (there);

	// done

    return (handle);
}

BinaryTable::BinaryTableErrors BinaryTable::remove (UINT_32 handle)
{
    BinaryTableErrors rc;

    if (m_table.remove (handle, NULL)) {
	rc = e_Ok;
    } else {
	rc = e_NotFound;
    }

    return (rc);
}
