/* Agent Tcl
   Bob Gray
   5 August 1998

   suppBinaryTable.h

   This file defines class BinaryTable, which maps handles to BinaryData
   instances.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SUPP_BINARY_TABLE_H
#define _SUPP_BINARY_TABLE_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_SIZES_H
#include "platSizes.h"
#endif
#ifndef _SUPP_HASH_H
#include "suppHash.h"
#endif

class BinaryData;
class BinaryDataStructure;

class BinaryTable
{
public:

    enum BinaryTableErrors {
	e_Ok,
	e_NotFound
    };

	// constructor and destructor

    BinaryTable (void);
   ~BinaryTable ();

	// add, find and remove BinaryData instances

    UINT_32 add 
	(const BinaryData &binaryData);

    BinaryTableErrors replace
	(UINT_32 handle, const BinaryDataStructure &structure);

    BinaryTableErrors getCopy
	(UINT_32 handle, BinaryDataStructure &structure);
	
    BinaryTableErrors remove
	(UINT_32 handle);

private:

	// copy constructor and assignment operator are not implemented

    BinaryTable (const BinaryTable &): m_table (0) {
	// empty
    }

    BinaryTable &operator= (const BinaryTable &) {
	return (*this);
    }

    Hash m_table;		// handle-to-BinaryData map
    UINT_32 m_nextHandle;	// handle for next BinaryData instance
};

#endif
